/*
	iPOpenGLUtilities.h
	
	Author:			Ivan Pinzon
	Description:	Various functions for
					- importing images into textures
					- error handling

	Creation date:	Feb 04/05
	Last Update:	Feb 04/05
*/

#ifndef iPOpenGLUtilities_H
#define iPOpenGLUtilities_H

#include <Carbon/Carbon.h>

#include <GLUT/glut.h>

class iPOpenGLUtilities
{
public:
	// prototypes
	static void strokeString(GLfloat x, GLfloat y, GLfloat z, GLfloat scale, char *text);
	static void drawBitmapString(GLfloat x, GLfloat y, GLfloat z, char *string);
	
	static GLubyte * LoadTextureFromFSRef(FSRef inImageFSRef, short inWidth, short inHeight);
	static void InitTexture(short inWidth, short inHeight, GLubyte* &ioTexturePtr);

	static OSErr CreateTextureGWorld(short inWidth, short inHeight, GLubyte * inTexturePtr, GWorldPtr &outOffscreenGW);

	static void	CheckOSStatus(OSStatus inResult);

	static void	CheckOSErr(OSErr inResult);
};


#endif // iPOpenGLUtilities_H